/************************************************************************************
** Check.js - JAVASCRIPT Funktionensammlung fr Lernspiel "Mnzen ordnen",         **
** programmiert im Wintersemester 2003/04 fr Dr. Sabine Panzram, Uni Hamburg, von **
** Christoph Nagel (post@cjfnagel.de).                                             **
** Bentigt die Drag-and-Drop Library von Walter Zorn (http://www.walterzorn.de).  **
** Die Weitergabe dieses Codes an Dritte ist untersagt und bedarf                  **
** der schriftlichen Genehmigung von Dr. Sabine Panzram oder Christoph Nagel.      **
************************************************************************************/

var muenzeInSlot = new Array(10);
/*Dieses Array wird genutzt, um zu prfen, ob alle Lsungspltze mit Mnzen belegt sind.
Dazu wird die Summe aller Array-Eintrge herangezogen.*/

function slotsbelegt () {
/*Diese Funktion berprft anhand einer Checksumme (1+2+3+...AnzahlSlots), ob alle Slots mit Mnzen belegt sind.*/
  var i = 0;
  var summe = 0;
  while (i<10) {
    summe = summe + muenzeInSlot[i];
    i++;
  }
  if (summe == 55) return true;
  else return false;
}

function einfrieren () {
/*Diese Funktion sorgt dafr, dass die Mnzen nicht mehr verschoben werden knnen.
Sie wird erst aufgerufen, wenn alle Mnzen richtig positioniert sind.*/
	var i=1;
         while (i < 11) {
		currentelement = "img" + i;
         	dd.elements[currentelement].setDraggable(false);
         	i++;
                 }
}

function ausgabe() {
/*Diese Funktion gibt Informationen ber Art und Inhalt der Mnzen aus.
Sie wird nur aufgerufen, wenn alle Mnzen auf den richtigen Positionen sind.*/

  var message = new Array(12);

  /*Lange Beschreibungen
  message[0] = "<b>Elektronstater,</b><br>Ionien oder Lydien,<br>nach 650 v.&nbsp;Chr., VS Geriefelte Flche, RS Vertiefungen";
  message[1] = "<b>Tetradrachmon,</b><br>Athen, um 550-530 v.&nbsp;Chr., VS Gorgoneion, RS Rinderkopf";
  message[2] = "<b>Stater,</b><br>Metapontion, um 530-500 v.&nbsp;Chr., VS und RS Gerstenhre";
  message[3] = "<b>Stater,</b><br>Aigina, um 480-457 v.&nbsp;Chr., VS Seeschildkrte, RS Quadratum incusum";
  message[4] = "<b>Tetradrachmon,</b><br>Rhegion, um 460/50 v.&nbsp;Chr., VS Lwenskalp, RS Iokastes";
  message[5] = "<b>Tetradrachmon,</b><br>Akragas, um 450 v.&nbsp;Chr., VS Adler, RS Krabbe";
  message[6] = "<b>Tetradrachmon,</b><br>Mende, um 460-420 v.&nbsp;Chr., VS Dionysos auf Esel lagernd, RS Quadrat mit Rebstock";
  message[7] = "<b>Tetradrachmon,</b><br>Athen, um 440-425 v.&nbsp;Chr., VS Athena, RS Eule";
  message[8] = "<b>Dekadrachmon,</b><br>Syrakus, um 412-407 v.&nnsp:Chr.<br>VS Viergespann; RS Artemis-Arethusa, signiert von Kimon";
  message[9] = "<b>Tetradrachmon,</b><br>Amphipolis, um 390-357 v.&nbsp;Chr., VS Apollonkopf, RS Zierquadrat mit Fackel";
  message[10] = "<b>Stater,</b><br>Aigina, um 350-320 v.&nbsp;Chr., VS Landschildkrte, RS Quadratum incusum";
  message[11] = "<b>Tetradrachmon,</b><br>Knigreich Makedonien, um 326-318 v.&nbsp;Chr., VS Kopf des Herakles, RS Zeus thronend";
  */

  /*Kurze Beschreibungen*/
  message[0]  = "<b>Elektronstater,</b><br>Ionien oder Lydien,<br>nach 650 v.&nbsp;Chr.";//Einfacher Stater
//  message[1]  = "<b>Tetradrachmon,</b><br>Athen, um 550-530 v.&nbsp;Chr.";
  message[1]  = "<b>Stater,</b><br>Korinth, um 620-580 v.&nbsp;Chr."; //Pegasos
  message[2]  = "<b>Tetradrachmon,</b><br>Athen, um 550-530 v.&nbsp;Chr."; //Gorgoneion
  message[3]  = "<b>Stater,</b><br>Metapontion, um 530-500 v.&nbsp;Chr."; //hre
  message[4]  = "<b>Tetradrachmon,</b><br>Akragas, um 450 v.&nbsp;Chr."; //Adler
  message[5]  = "<b>Tetradrachmon,</b><br>Rhegion, um 450/440 v.&nbsp;Chr."; //Lwe
  message[6]  = "<b>Tetradrachmon,</b><br>Athen, um 440-425 v.&nbsp;Chr."; //Athena
  message[7]  = "<b>Dekadrachmon,</b><br>Syrakus, um 412-407 v.&nbsp;Chr."; //Quadriga
  message[8] = "<b>Tetradrachmon,</b><br>Knigr. Makedonien, um 326-318 v.&nbsp;Chr.";
  message[9] = "<b>Tetradrachmon,</b><br>Knigr. Makedonien, 179-168 v.&nbsp;Chr."; //Perseus

  var i = 0;

  while (i < 10) {

	var slotname = "start"+(i+1);
	var slot = dd.elements[slotname];
	text = message[i];

	slot.write(text);

	i++;
  }

}

function check() {
/*Diese Funktion prft, ob die Aufgabe korrekt ausgefhrt wurde.
  Die Zuordnung der Mnzen zu den Slots (graue Quadrate) erfolgt im Array "loesung" und kann so
  leicht gendert werden. */

  var loesung = new Array(10);

  /*Hier wird festgelegt, welche Mnze in welchen Slot gehrt.*/

  loesung[0] = "img5";
  loesung[1] = "img3";
  loesung[2] = "img10";
  loesung[3] = "img7";
  loesung[4] = "img9";
  loesung[5] = "img2";
  loesung[6] = "img1"
  loesung[7] = "img4";
  loesung[8] = "img8";
  loesung[9] = "img6";

  allesrichtig = new Boolean(true); //sobald im weiteren Verlauf ein Fehler festgestellt wird, wird dieses Boolean-Objekt auf FALSE gesetzt!

  //Prfen, ob alle Lsungs-Slots belegt sind. Falls nicht, alle Slots auf Farbwert "grau" setzen und abbrechen.
  if (!slotsbelegt()) {

  var i = 0;

  while (i < 10) {

	var slotname = "slot"+(i+1);
	var slot = dd.elements[slotname];
    	slot.setBgColor("#EEEEEE");
         i++;
         }

  //alert ("Bitte schieben Sie zunchst die Mnzen auf die grauen Quadrate.\n\nDie Reihenfolge sollte dabei dem Alter der Mnzen entsprechen.\n\nWenn alle grauen Quadrate mit Mnzen belegt sind,\nklicken Sie bitte erneut auf den Button \"Prfen\",\num festzustellen, ob die Reihenfolge der Mnzen stimmt.");

  return false;
  }


  var i = 0;

  //Fr alle Mnzen wird nacheinander festgestellt, ob sie "richtig" liegen.
  while (i < 10) {

	var temp = loesung[i];
	var bild = dd.elements[temp];

	var slotname = "slot"+(i+1);
	var slot = dd.elements[slotname];

	if (
	(bild.x >= slot.x)
   	&&((bild.x + bild.w) <= (slot.x + slot.w))

	&&

	(bild.y >= slot.y)&&((bild.y + bild.h) <= (slot.y + slot.h))
	&&(bild.y != bild.defy)
	)

		{
		  //Resultat richtig: grne Farbe.
		  slot.setBgColor("#008000");
		}

	else

         	{
		  //Resultat falsch: rote Farbe.
		  slot.setBgColor("#BA0138");
                   allesrichtig = false;
         	}

	i++;

  }

  if (allesrichtig) {
         einfrieren(); //Drag-and-Drop-Fhigkeit ausschalten
         document.formular.comment.value=" Glckwunsch! Sie haben die Mnzen richtig angeordnet.";
	ausgabe();    //Lsungen anzeigen
         }
  else   document.formular.comment.value=" Leider ist Ihre Reihenfolge noch nicht ganz richtig.";

}

function snap(){
/*Diese Funktion sorgt dafr, dass die Mnzen nicht einfach irgendwo abgelegt werden knnen,
sondern durch eine Art "Gitternetz" gleichmig und sauber ausgerichtet werden.*/

  var muenze = dd.elements[document.aktiv]; //letzte bewegte Mnze
  var muenznummer = muenze.name.substr(3, muenze.name.length); //Nummer der Mnze; wird gebildet aus dem Bildnamen (z.B. img1);

  var abstand = 10; //Abstand zwischen den Mnzfeldern und Slots
  var xanzahlslots = 5; //Anzahl Spalten
  var yanzahlslots = 4; //Anzahl Zeilen

  /* An dieser Stelle wird das Feld abgegenzt, innerhalb dessen die gleichmig groen Felder liegen.
  Damit diese trotz Abstnden gleichmig sein knnen, wird auch dem jeweils linken bzw. oberen
  Mnzfeld noch ein Abstand zugeordnet.*/

  var xmin = dd.elements.start1.x - abstand;
  var xmax = dd.elements.start10.x + dd.elements.start10.w + abstand;

  var ymin = dd.elements.start1.y - abstand;
  var ymax = dd.elements.start10.y + dd.elements.start10.h + abstand;

  var currentx = muenze.x;
  var currenty = muenze.y;

  //Sicherstellen, dass keine Koordinaten auerhalb des Slot-Gebietes vorkommen
  if (currentx < xmin) currentx = xmin; if ((currentx + muenze.w) > xmax) currentx = xmax - muenze.w;
  if (currenty < ymin) currenty = ymin; if ((currenty + muenze.h) > ymax) currenty = ymax - muenze.h;

  //Gesamte Breite des Ablagefeldes ausrechnen
  var totalwidth =  xmax - xmin;
  var totalheight = ymax - ymin;

  //Ausrechnen, in welcher Spalte (colaktuell) und wlecher Zeile sich die Mnze ungefhr befindet
  var colaktuell = Math.round((currentx - (xmin-muenze.w)) / ((totalwidth) / xanzahlslots));
  var rowaktuell = Math.round(currenty /  (totalheight / yanzahlslots));


  //window.status="xmin: "+xmin+" ymin: "+ymin+" currentx: "+currentx+" currenty: "+currenty+" xslot: "+colaktuell+" yslot: "+rowaktuell+" totalwidth: "+totalwidth;

  //Alert fr Testzwecke, im Normalbetrieb deaktiviert
  //alert ("Wir sind in Spalte " + colaktuell + " und in Reihe: " +rowaktuell);

  /*Snap-Funktion: Mnzen in die Mitte des nchstmglichen Slots verschieben.
  Diese Funktion funktioniert im Moment nur, wenn genau 4 Reihen vorhanden sind,
  von denen die mittleren zwei fr die Ablage der Mnzen zur Lsung bestimmt sind -
  sicher eine Schwche, aber die Zeit drngt...*/


  if (rowaktuell > 0 && rowaktuell <3) {
	var slotnummer = colaktuell+((rowaktuell-1)*xanzahlslots);
	var slotname   = "slot"+slotnummer;
	var slot       = dd.elements[slotname];
	muenznummer = muenznummer -1;
         muenzeInSlot[muenznummer] = slotnummer;
         }

  else if (rowaktuell == 0) {
         var slotname = "start"+ colaktuell;
	var slot     = dd.elements[slotname];
	muenznummer = muenznummer -1;
         muenzeInSlot[muenznummer] = 99;
         }

  else if (rowaktuell == 3) {
         var slotname = "start" + (colaktuell + 5);
	var slot     = dd.elements[slotname];
	muenznummer = muenznummer -1;
         muenzeInSlot[muenznummer] = 99;
         }

  var zielx = slot.x+((slot.w - muenze.w)/2); //Errechnet X-Koordinate fr horizontale Zentrierung im Ziel-Slot
  var ziely = slot.y+((slot.h - muenze.h)/2); //Errechnet Y-Koordinate fr horizontale Zentrierung im Ziel-Slot

  muenze.moveTo(zielx,ziely); //Fhrt Zentrierung aus

  return true;

}