/************************************************************************************
** check_kalender.js - JAVASCRIPT Funktionensammlung fr Lernspiel "Rm. Kalender",**
** programmiert 2004-6 fr Dr. Sabine Panzram, Uni Hamburg, von                    **
** Christoph Nagel (post@cjfnagel.de).                                             **
** Bentigt die Drag-and-Drop Library von Walter Zorn (http://www.walterzorn.de).  **
** Die Weitergabe dieses Codes an Dritte ist untersagt und bedarf                  **
** der schriftlichen Genehmigung von Dr. Sabine Panzram oder Christoph Nagel.      **
************************************************************************************/

var aufgabe = new Array(); var loesung = new Array();

aufgabe[0]="27. Oktober ="; loesung[0]="VI kalendas novembres";
aufgabe[1]="01. Januar ="; loesung[1]="kalendis ianuarias";
aufgabe[2]="04. November ="; loesung[2]="pridie nonas novembres";
aufgabe[3]="13. Februar ="; loesung[3]="idibus februarias";
aufgabe[4]="14. Dezember ="; loesung[4]="XIX kalendas ianuarias";

var counter = 0;
var richtig = 0;
var falsch  = 0;

var datum = new Array(6);

var toleranz = 30;  // Ungenauigkeitstoleranz der Positionierung
var slotnumber  = 6; // "Snap"-Einteilung des Ergebnisfeldes

function stringTrim(strToTrim) {

	return(strToTrim.replace(/^\s+|\s+$/g, ''));
}

function snap(last){
/*Diese Funktion sorgt dafr, dass die "Datumsplttchen"  nicht einfach irgendwo abgelegt werden knnen,
sondern durch eine Art "Gitternetz" gleichmig und sauber ausgerichtet werden.*/

  var plaettchen = last; //letztes bewegtes Plttchen

  var xmin = dd.elements.ergebnisfeld.x;
  var xmax = dd.elements.ergebnisfeld.x + dd.elements.ergebnisfeld.w;

  var ymin = (dd.elements.ergebnisfeld.y - toleranz);
  var ymax = (dd.elements.ergebnisfeld.y + dd.elements.ergebnisfeld.h + toleranz);

  var currentx = plaettchen.x;
  var currenty = plaettchen.y;
  var relpos   = currentx - xmin;

  var ziely = dd.elements.ergebnisfeld.y;

  //Gesamte Breite des Ablagefeldes ausrechnen
  var totalwidth  = xmax - xmin;
  var totalheight = ymax - ymin;
  var distanz     = totalwidth / slotnumber;

  var col = Math.round(relpos / distanz);

if ((currenty > ymin) && (currenty < ymax)) {

  if (col<0) col=0;
  if (col>=slotnumber)col=5;
  if (datum[col])col=col+1;//Falls schon belegt, einen weiter.
  var posx = xmin + (col* ((totalwidth) / 6));
  plaettchen.moveTo(posx,ziely);
  datum[col] = plaettchen.name;

}

  else {
  plaettchen.moveTo(plaettchen.defx,plaettchen.defy); //Zurck auf Ausgangsposition
  }

  return true;
}

function delcol (last) {
  //Lscht den zur Plttchenposition gehrenden Eintrag im Lsungsvorschlag

  var plaettchen = last; //letztes bewegtes Plttchen

  var xmin = dd.elements.ergebnisfeld.x;
  var xmax = dd.elements.ergebnisfeld.x + dd.elements.ergebnisfeld.w;

  var ymin = (dd.elements.ergebnisfeld.y - toleranz);
  var ymax = (dd.elements.ergebnisfeld.y + dd.elements.ergebnisfeld.h + toleranz);

  var currentx = plaettchen.x;
  var currenty = plaettchen.y;
  var relpos   = currentx - xmin;

  var ziely = dd.elements.ergebnisfeld.y;

  //Gesamte Breite des Ablagefeldes ausrechnen
  var totalwidth  = xmax - xmin;
  var totalheight = ymax - ymin;
  var distanz     = totalwidth / slotnumber;

  var col = Math.round(relpos / distanz);

if ((currenty > ymin) && (currenty < ymax))
   if (col>=0 && col < slotnumber) datum[col] = "";

}

function check(counter) {

if (loesung[counter] == document.ergebnis.ausgabe.value)
    {
    dd.elements.ergebnisfeld.setBgColor("#008000");//richtig
    richtig = richtig +1;
    }

    else {
        dd.elements.ergebnisfeld.setBgColor("#BA0138");
        falsch = falsch +1;
        }

    document.ergebnis.zaehler.value="Richtige Lsungen: "+richtig+", falsche Lsungen: "+falsch;
}

function weiter() {
  setback();
  counter = counter +1;
  if (aufgabe[counter]) document.task.aufgabenstellung.value=aufgabe[counter];
  else {counter = 0; document.task.aufgabenstellung.value=aufgabe[counter];}
  }


function setback(){

var max = dd.elements.length;

for (i = 0; i < max; i++) {
    var plaettchen = dd.elements[i];
    if(plaettchen.setDraggable) plaettchen.moveTo(plaettchen.defx,plaettchen.defy);
}

var max = datum.length;

for (i = 0; i < max; i++) datum[i]="";
document.ergebnis.ausgabe.value ="";

dd.elements.ergebnisfeld.setBgColor("#FFFFFF");

}