/************************************************************************************
** Check.js - JAVASCRIPT Funktionensammlung fr Lernspiel "Mnzen ordnen",         **
** programmiert im Wintersemester 2003/04 fr Dr. Sabine Panzram, Uni Hamburg, von **
** Christoph Nagel (post@cjfnagel.de).                                             **
** Bentigt die Drag-and-Drop Library von Walter Zorn (http://www.walterzorn.de).  **
** Die Weitergabe dieses Codes an Dritte ist untersagt und bedarf                  **
** der schriftlichen Genehmigung von Dr. Sabine Panzram oder Christoph Nagel.      **
************************************************************************************/

var inSlot = new Array(16);
/*Dieses Array wird genutzt, um zu prfen, ob alle Lsungspltze belegt sind.
Dazu wird die Summe aller Array-Eintrge herangezogen.*/

function positioniert () {
/*Diese Funktion berprft anhand einer Checksumme, ob alle Slots belegt sind.*/

  var karte = dd.elements.karte;
  var i=1;
  while (i < 17) {
         var currentname = "ort" + i;
         var current     = dd.elements[currentname];
 	if (((current.x > karte.x)&&(current.x<(karte.x+karte.w)))&&
             ((current.y > karte.y)&&(current.y<(karte.y+karte.h))))
       	i++;
         else return false;
   }

   return true;
}

function einfrieren () {
/*Diese Funktion sorgt dafr, dass die Orte nicht mehr verschoben werden knnen.
Sie wird erst aufgerufen, wenn alle Mnzen richtig positioniert sind.*/
	var i=1;
         while (i < 17) {
		currentelement = "ort" + i;
         	dd.elements[currentelement].setDraggable(false);
         	i++;
                 }
}

function koordinaten(x,y,ex1,ey1,ex2,ey2) {
/* Diese Funktion konstruiert ein Objekt, in dem spter die Parameter der Lsung gespeichert werden.*/
  this.x = x;
  this.y = y;
  this.ex1 = ex1;
  this.ey1 = ey1;
  this.ex2 = ex2;
  this.ey2 = ey2;
}

function check() {
/*Diese Funktion prft, ob die Aufgabe korrekt ausgefhrt wurde.
  Die Zuordnung der Mnzen zu den Slots (graue Quadrate) erfolgt im Array "loesung" und kann so
  leicht gendert werden. */

  var loesung = new Array(16);

  /*Hier wird festgelegt, welche Mnze in welchen Slot gehrt.
  Die ersten Zahlen bezeichnen die genaue Lsung (x,y);
  die folgenden vier Zahlen beschreiben als x/y der oberen linken und unteren echten Ecke ein Rechteck.
  Alle Koordinaten innerhalb des Rechtecks gelten bei der Lsungsprfung als korrekt.
  */

  loesung[0]  = new koordinaten(260,198,250,188,270,208); //Athen
  loesung[1]  = new koordinaten(370,242,360,234,380,252); //Delos
  loesung[2]  = new koordinaten(170,143,160,133,180,153); //Delphi
  loesung[3]  = new koordinaten(261,145,246,135,296,165); //Euba
  loesung[4]  = new koordinaten(200,206,195,201,205,211); //Korinth
  loesung[5]  = new koordinaten(349,436,249,417,447,460); //Kreta
  loesung[6]  = new koordinaten(191,225,186,220,201,235); //Mykene
  loesung[7]  = new koordinaten(38,173,28,163,48,183);    //Kephallenia
  loesung[8]  = new koordinaten(510,230,500,220,520,240); //Milet
  loesung[9]  = new koordinaten(309,308,299,298,319,318); //Melos
  loesung[10] = new koordinaten(104,218,96,208,114,228); //Olympia
  loesung[11] = new koordinaten(362,274,352,264,372,284); //Paros
  loesung[12] = new koordinaten(182,286,172,276,192,296); //Sparta
  loesung[13] = new koordinaten(563,346,553,336,573,356); //Rhodos
  loesung[14] = new koordinaten(427,26,417,16,437,36);  //Troia
  loesung[15] = new koordinaten(313,118,303,108,323,128); //Skyros

  allesrichtig = new Boolean(true); //sobald im weiteren Verlauf ein Fehler festgestellt wird, wird dieses Boolean-Objekt auf FALSE gesetzt!

  //Prfen, ob alle Orte bewegt wurden. Falls nicht, abbrechen

  if (!positioniert()) {

  var i = 0;

  while (i < 16) {

	var ortsname = "ort"+(i+1);
	var ort = dd.elements[ortsname];
    	ort.setBgColor("#FFFFFF");
         i++;
         }

  dd.elements.pruefmessage.maximizeZ();
  dd.elements.pruefmessage.show();

  return false;
  }


  var i = 0;
  var karte = dd.elements.karte;

  //Fr alle Orte wird nacheinander festgestellt, ob sie "richtig" liegen.
  while (i < 16) {

	var ortsname = "ort"+(i+1);
	var ort = dd.elements[ortsname];

         var loesungx = loesung[i].x+karte.x;
         var loesungy = loesung[i].y+karte.y;

         var loesungex1 = loesung[i].ex1;//X-Koordinate der oberen linken Ecke des erweiterten Lsungsfeldes
         var loesungex2 = loesung[i].ex2;//X-Koordinate der unteren rechten Ecke des erweiterten Lsungsfeldes

         var loesungey1 = loesung[i].ey1;//Y-Koordinate der oberen linken Ecke des erweiterten Lsungsfeldes
         var loesungey2 = loesung[i].ey2;//Y-Koordinate der unteren rechten Ecke des erweiterten Lsungsfeldes

         var relativex = ort.x-karte.x;
         var relativey = ort.y-karte.y;

         //berprfung, ob der Ort innerhalb des gltigen Koordinatenfeldes positioniert wurde.
          if (
             ((relativex > loesungex1) && (relativex < loesungex2)) &&
             ((relativey > loesungey1) && (relativey < loesungey2))
	)
                 {
		  //Resultat richtig: grne Farbe.
		  ort.setBgColor("#008000");//Ortsbezeichnung wird grn hinterlegt, da richtig.
		  ort.moveTo(loesungx,loesungy);//Ort wird auf "amtliche" Position verschoben.
                   ort.setDraggable(false);//Ort kann nun nicht mehr verschoben werden.
		}

	else

         	{
		  //Resultat falsch: rote Farbe.
		  ort.setBgColor("#BA0138");
		  //ort.write("<font color=white>Leider&nbsp;falsch.</font>");//an sich nett, aber zu langsam, daher auskommentiert
                   allesrichtig = false;
         	}

	i++;

  }

  if (allesrichtig) {
         einfrieren(); //Drag-and-Drop-Fhigkeit ausschalten
         document.formular.comment.value=" Glckwunsch! Sie haben die Karte richtig vervollstndigt.";
         }
  else   {
  	document.formular.comment.value=" Leider ist Ihr Lsungsvorschlag noch nicht ganz richtig.";
	/*einverstanden = confirm("Lsung anzeigen?");//Fr Debugging-Zwecke: Mglichkeit, Lsung direkt anzuzeigen.
         if (einverstanden)loesungzeigen(loesung);*/
         }

}

function loesungzeigen(loesung) {
/*Diese Funktion schiebt die Ortsbezeichnungen auf die als Lsung vorgesehenen Positionen.*/

  var i = 0;

  //Fr alle Orte wird nacheinander festgestellt, ob sie "richtig" liegen.
  while (i < 16) {

	var ortsname = "ort"+(i+1);
	var ort = dd.elements[ortsname];

         var loesungx = loesung[i].x;
         var loesungy = loesung[i].y;

         var karte = dd.elements.karte;

         var relativex = loesungx+karte.x;
         var relativey = loesungy+karte.y;

	ort.setBgColor("#ffffff");
	ort.moveTo(relativex,relativey);
         ort.maximizeZ();

	i++;

  }
}

function snap(){
/*Diese Funktion sorgt auf Wunsch dafr, dass die Punkte nicht einfach irgendwo auf der Karte gesetzt werden knnen,
sondern durch eine Art "Gitternetz" gleichmig und sauber ausgerichtet werden. */

  var ort = dd.elements[document.aktiv]; //letzte bewegte Mnze
  var ortsnummer = ort.name.substr(3, ort.name.length); //Nummer der Mnze; wird gebildet aus dem Bildnamen (z.B. img1);

  var abstand = 0; //Abstand zwischen den Mnzfeldern und Slots
  var xanzahlslots = 65; //Anzahl Spalten
  var yanzahlslots = 52; //Anzahl Zeilen

  /* An dieser Stelle wird das Feld abgegenzt, innerhalb dessen die gleichmig groen Felder liegen.
  Damit diese trotz Abstnden gleichmig sein knnen, wird auch dem jeweils linken bzw. oberen
  Mnzfeld noch ein Abstand zugeordnet.*/

  var xmin = dd.elements.karte.x - abstand;
  var xmax = dd.elements.karte.x + dd.elements.karte.w + abstand;

  var ymin = dd.elements.karte.y - abstand;
  var ymax = dd.elements.karte.y + dd.elements.karte.h + abstand;

  var currentx = ort.x;
  var currenty = ort.y;

  var relativex = ort.x-xmin;
  var relativey = ort.y-ymin;

  document.formular.comment.value="X: "+relativex+", Y: "+relativey;

  //Sicherstellen, dass keine Koordinaten auerhalb des Slot-Gebietes vorkommen
  if (currentx < xmin) currentx = xmin; if ((currentx + ort.w) > xmax) currentx = xmax - ort.w;
  if (currenty < ymin) currenty = ymin; if ((currenty + ort.h) > ymax) currenty = ymax - ort.h;

  //Gesamte Breite des Ablagefeldes ausrechnen
  var totalwidth  = xmax - xmin;
  var totalheight = ymax - ymin;

  var xfactor     = (totalwidth / xanzahlslots);
  var yfactor     = (totalheight / yanzahlslots);

  //Ausrechnen, in welcher Spalte (colaktuell) und welcher Zeile sich die Mnze befindet
  var colaktuell = Math.round((currentx - xmin) / xfactor);
  var rowaktuell = Math.round((currenty - ymin) / yfactor);


  //window.status="xmin: "+xmin+" ymin: "+ymin+" currentx: "+currentx+" currenty: "+currenty+" xslot: "+colaktuell+" yslot: "+rowaktuell+" totalwidth: "+totalwidth;

  //Alert fr Testzwecke, im Normalbetrieb deaktiviert
  //alert("current x :"+(currentx-xmin) +" current y:"+(currenty-ymin));
  //alert ("Wir sind in X-Streifen " + colaktuell + " und in Y-Streifen: " +rowaktuell);

  /*Snap-Funktion: Mnzen in die Mitte des nchstmglichen Slots verschieben.
  Diese Funktion funktioniert im Moment nur, wenn genau 4 Reihen vorhanden sind,
  von denen die mittleren zwei fr die Ablage der Mnzen zur Lsung bestimmt sind -
  sicher eine Schwche, aber die Zeit drngt...*/

  var karte = dd.elements.karte;

/*  var zielx = Math.round(karte.x+((karte.w/xanzahlslots)*colaktuell)); //Errechnet X-Koordinate fr horizontale Zentrierung im Ziel-Slot
  var ziely = Math.round(karte.y+((karte.h/yanzahlslots)*rowaktuell)); //Errechnet Y-Koordinate fr horizontale Zentrierung im Ziel-Slot*/

  var zielx = Math.round(karte.x + (colaktuell*xfactor));
  var ziely = Math.round(karte.y + (rowaktuell*yfactor));

  //alert("ziel-x= "+zielx+" ziel-y= "+ziely);

  ort.moveTo(zielx,ziely); //Fhrt Zentrierung aus

  return true;

}